<?php
/*
Plugin Name: Sibelius Embed
Version: 0.1
Plugin URI: http://www.jiinjoo.com/wp/sibeilusembed
Description: Embeds Sibelius Scorch into your wordpress blog. The syntax is <code>[sibembed score=&quot;filename.sib&quot; height=&quot;896&quot; width=&quot;604&quot; align=&quot;bottom&quot;/]</code>.
Author: Ong Jiin Joo
Author URI: http://www.jiinjoo.com

Modified from: http://kimili.com/plugins/kml_flashembed/wp (for parsing)
*/

// Setup / declarations
$sibembed_request_type = "";
$sibembed_root         = get_settings('siteurl') . '/wp-content/plugins/'.dirname(plugin_basename(__FILE__));

if( !class_exists('buttonsnap') )
	require_once ('buttonsnap.php');

// Option name => Display name, Default value, Size of the field, Description
$se_opt = array(
	'se_opt_width' => array('Width', '604', '5', 'A4:595, Ltr:612, Tabloid:792'),
	'se_opt_height' => array('Height', '896', '5', 'A4:842, Ltr:792, Tabloid:1224'),
	'se_opt_align' => array('Align', 'CENTER', array('', 'ABSBOTTOM', 'ABSMIDDLE', 'MIDDLE', 'TEXTTOP', 'RIGHT', 'LEFT', 'BASELINE', 'CENTER', 'BOTTOM', 'TOP'), 'HTML align'),
	'se_opt_scorch_command' => array('Command', 'View', '30', ''),
	'se_opt_scorch_num_copies' => array('Num Copies', '1', '5', ''),
	'se_opt_scorch_security' => array('Security', 'challengeResponse', '30', ''),
	'se_opt_scorch_first_page_footer' => array('First Page Footer', 'Sample: NOT TO BE USED FOR PERFORMANCE OR RESALE', '80', ''),
	'se_opt_scorch_second_page_footer' => array('Second Page Footer', '', '80', ''),
	'se_opt_scorch_preferred_version' => array('Preferred Version', '3000', '5', 'Sib3:3000, Sib4:5210, Sib5:5210'),
	'se_opt_scorch_minimum_version' => array('Minimum Version', '2800', '5', 'Sib3:2800, Sib4:4000, Sib5:5210'),
	'se_opt_scorch_shrink_limit' => array('Shrink Limit', '90', '5', ''),
	'se_opt_scorch_transposition' => array('Transposition', '', '30', ''),
	'se_opt_scorch_instrument' => array('Instrument', '', '30', ''),
	'se_opt_scorch_cart_id' => array('Cart ID', '', '5', ''),
	'se_opt_scorch_arg_1' => array('Scorch Argument 1', '', '30', ''),
	'se_opt_scorch_arg_2' => array('Scorch Argument 2', '', '30', ''),
	'se_opt_scorch_arg_3' => array('Scorch Argument 3', '', '30', ''),
	'se_opt_scorch_arg_4' => array('Scorch Argument 4', '', '30', ''),
	'se_opt_scorch_arg_5' => array('Scorch Argument 5', 'en-GB', '30', 'en-GB, en-US, etc.'),
	'se_opt_scorch_arg_6' => array('Scorch Argument 6', '', '30', ''),
	'se_opt_scorch_arg_7' => array('Scorch Argument 7', '', '30', ''),
	'se_opt_scorch_arg_8' => array('Scorch Argument 8', '', '30', ''),
);

//
// Text parsing
//
function sibembed($content) {
	$pattern = '/(<p>[\s\n\r]*)??(([\[<]SIBEMBED.*\/[\]>])|([\[<]SIBEMBED.*[\]>][\[<]\/SIBEMBED[\]>]))([\s\n\r]*<\/p>)??/Umi'; 
	$result = preg_replace_callback($pattern,'sibembed_parse_tags',$content);
	return $result;	
}

function sibembed_parse_tags($match) {
		
	$r	= "";
			
	# Clean up and untexturize tag
	$strip		= array('[SIBEMBED',
						'][/SIBEMBED]',
						'[sibembed',
						'][/sibembed]',
						'/]',
						'<SIBEMBED',
						'></SIBEMBED>',
						'<sibembed',
						'></sibembed>',
						'/>',
						'\n',
						'<br>',
						'<br />',
						'<p>',
						'</p>'
						);
						
	$elements	= str_replace($strip, '', $match[0]);
	
	$elements	= preg_replace("/=(\s*)\"/", "==`", $elements);
	$elements	= preg_replace("/=(\s*)&Prime;/", "==`", $elements);
	$elements	= preg_replace("/=(\s*)&prime;/", "==`", $elements);
	$elements	= preg_replace("/=(\s*)&#8221;/", "==`", $elements);
	$elements	= preg_replace("/\"(\s*)/", "`| ", $elements);
	$elements	= preg_replace("/&Prime;(\s*)/", "`|", $elements);
	$elements	= preg_replace("/&prime;(\s*)/", "`|", $elements);
	$elements	= preg_replace("/&#8221;(\s*)/", "`|", $elements);
	$elements	= preg_replace("/&#8243;(\s*)/", "`|", $elements);
	$elements	= preg_replace("/&#8216;(\s*)/", "'", $elements);
	$elements	= preg_replace("/&#8217;(\s*)/", "'", $elements);
	
	$attpairs	= preg_split('/\|/', $elements, -1, PREG_SPLIT_NO_EMPTY);
	$atts		= array();
	
	// Create an associative array of the attributes
	for ($x = 0; $x < count($attpairs); $x++) {
		
		$attpair		= explode('==', $attpairs[$x]);
		$attn			= trim(strtolower($attpair[0]));
		$attv			= preg_replace("/`/", "", trim($attpair[1]));
		$atts[$attn]	= $attv;
	}
	
	// Only compulsory param is the score
	if (isset($atts['score'])) {
		
		// If we're not serving up a feed, generate the script tags !?!?!?
		if ($GLOBALS['sibembed_request_type'] != "feed") {
			$r	= sibembed_build_tag($atts);
		} else {
			$r	= sibembed_build_tag($atts);
		}
	}
 	return $r; 
}

function sibembed_build_tag($atts) {
	
	global $sibembed_root, $se_opt;
	$se_options = array();
	
	if (is_array($atts)) extract($atts);
	
    // Read in existing option value from database, leaving defaults
	foreach ( $se_opt as $opt_key => $opt_params ) {
		$stored_opt_val = get_option( $opt_key );
		if ( $stored_opt_val ) {
			$se_options[$opt_key] = $stored_opt_val;
		}
	}
	
	$width  = isset($width)  ? $width  : $se_options['se_opt_width'];
	$height = isset($height) ? $height : $se_options['se_opt_height'];
	$align  = isset($align)  ? $align  : $se_options['se_opt_align'];
	// TODO: to allowfor parameters to be one off from the post. Now only 3 arguments are checked, the rest comes from options
	
	$out	= array();
	$ret	= "";
		
	$out[] = '<object id="ScorchPlugin"';
	$out[] = ' classid="clsid:A8F2B9BD-A6A0-486A-9744-18920D898429"';
	$out[] = ' width="' . $width . '"';
	$out[] = ' height="' . $height . '"';
	$out[] = ' codebase="http://www.sibelius.com/download/software/win/ActiveXPlugin.cab#5,2,1,4">';
	$out[] = ' <param name="src" value="' . $score . '">';
	$out[] = ' <param name="type" value="application/x-sibelius-score">';
	foreach ($se_options as $key => $value) {
		$k = substr($key, 7);
		if (substr($k, 0, 7) == 'scorch_') {
			$out[] = ' <param name="' . $k . '" value="' . $value . '">';
		}
	}
	$out[] = ' <embed src="' . $score . '"';
	foreach ($se_options as $key => $value) {
		$k = substr($key, 7);
		if (substr($k, 0, 7) == 'scorch_') {
			$out[] = '  ' . $k . '="' . $value . '"';
		}
	}
	$out[] = '  width="' . $width . '"';
	$out[] = '  height="' . $height . '"';
	$out[] = '  align="' . $align . '"';
	$out[] = '  type="application/x-sibelius-score"';
	$out[] = '  pluginspage="http://www.sibelius.com/cgi/plugin.pl">';
	$out[] = ' </embed>';
	$out[] = '</object>';
	$out[] = '';
	$ret .= join("\n				", $out);
	return $ret;
}

//
// Output for Plugin
//
function sibembed_addbuttons() {  
  
	global $wp_db_version, $sibembed_root;  
 	
	// Check for WordPress 2.5+ and activated RTE
	if (  $wp_db_version >= 6846 && 'true' == get_user_option('rich_editing')  ) {  
		
		add_filter( 'mce_external_plugins', 'sibembed_plugin', 0 );
		add_filter( 'mce_buttons', 'sibembed_button',0 );
		
	// Check for WordPress 2.1+ and activated RTE
	} elseif ( 3664 <= $wp_db_version && 'true' == get_user_option('rich_editing') ) {  
		// add the button for wp21 in a new way  
		add_filter("mce_plugins", "sibembed_plugin", 0);  
		add_filter('mce_buttons', 'sibembed_button', 0);  
		add_action('tinymce_before_init','sibembed_load');
		
	}
	
	if (class_exists('buttonsnap')) {
		$button_image_url = $sibembed_root.'/images/scorch.gif';  
		buttonsnap_separator();  
		buttonsnap_ajaxbutton($button_image_url, __('Sibelius Embed', 'se'), 'sibembed_insert_hook');
		add_filter('sibembed_insert_hook', 'sibembed_insert_tag');
		
	}  
}

// used to insert button in wordpress 2.1x and 2.5 editor  
function sibembed_button($buttons) {  
	array_push($buttons, "separator", "se");  
	return $buttons;  
}
  
// Tell TinyMCE that there is a plugin 
function sibembed_plugin($plugins) {  
	
	global $sibembed_root, $wp_db_version;
	
	// WP 2.5
	if ( $wp_db_version >= 6846 )
		$plugins['se'] = $sibembed_root.'/se/editor_plugin_tmce3.js';
	// WP 2.1 - 2.3
	else
		array_push($plugins, "-se");  
	return $plugins;  
}

// Load the TinyMCE plugin : editor_plugin.js (wp2.1)  
function sibembed_load() {
	
	global $sibembed_root;
	
	$pluginURL = $sibembed_root.'/se/';
	
	echo 'tinyMCE.loadPlugin("se", "'.$pluginURL.'");'."\n"; 
	return;  
}

function sibembed_insert_tag($selectedtext) {
	return '[sibembed score="'. $selectedtext . '" height="" width="" /]';
}

//
// Apply the Filter
//
if (preg_match("/(\/\?feed=|\/feed)/i",$_SERVER['REQUEST_URI'])) {
	// RSS Feeds
	$sibembed_request_type	= "feed";
} else {
	// Everything else
	$sibembed_request_type	= "nonfeed";
	add_action('init', 'sibembed_addbuttons');
}

// Apply all over except the admin section
//if (strpos($_SERVER['REQUEST_URI'], 'wp-admin') === false ) {
//	add_action('template_redirect','seDoObStart');
//}
//function seDoObStart() {
//	ob_start('sibembed');
//}
add_filter('the_content', 'sibembed');



//
// Admin options
//
add_action('admin_menu', 'se_add_pages');

function se_add_pages() {
    add_options_page('Sibelius Embed', 'Sibelius Embed', 8, __FILE__, 'se_options_page');
}

function se_options_page() {

	global $se_opt;

	$se_options = array();
    $hidden_field_name = 'se_submit_hidden';

    // Read in existing option value from database, leaving defaults
	foreach ( $se_opt as $opt_key => $opt_params ) {
		$stored_opt_val = get_option( $opt_key );
		if ( $stored_opt_val ) {
			$se_options[$opt_key] = $stored_opt_val;
		}
	}
	
    // See if the user has posted us some information
    // If they did, this hidden field will be set to 'Y'
    if( $_POST[ $hidden_field_name ] == 'Y' ) {
		// Check for security
		if ( function_exists('check_admin_referer') ) {
			check_admin_referer('sibelius-embed-update-options');
		}
		foreach ( $se_opt as $opt_key => $opt_params ) {
	        // Read their posted value
	        $new_opt_val = $_POST[ $opt_key ];

	        // Save the posted value in the database
	        update_option( $opt_key, $new_opt_val );
			$se_options[$opt_key] = $new_opt_val;
		}
        // Put an options updated message on the screen
?>
<div class="updated"><p><strong>Maestro, your options have been saved. Thank you.</strong></p></div>
<?php
    }

    // Display the options editing screen
    ?>
<div class="wrap">
	<h2>Sibelius Embed Plugin Options</h2>
	<p>Disclaimer: As this is pretty much a reverse engineering of the Scorch embedding code, there's no way for me
	to validate if the information works or not. Most of the common values have been suggested. If you have no idea, 
	simply select the version of Sibelius you're using and change only the Width / Height / Align to your usual.</p>

	<form name="se_options_form" method="post" action="<?php echo str_replace( '%7E', '~', $_SERVER['REQUEST_URI']); ?>">
	<?php
	if ( function_exists('wp_nonce_field') )
		wp_nonce_field('sibelius-embed-update-options');
	?>
		<input type="hidden" name="<?php echo $hidden_field_name; ?>" value="Y">
		
		<fieldset class="options"> 
		<legend>All Options</legend> 
		<table width="100%" cellspacing="2" cellpadding="5" class="editform">
		<?php foreach ( $se_opt as $opt_key => $opt_params ) { ?>
			<tr valign="top"> 
			<th width="33%" scope="row"><?php echo $opt_params[0]; ?></th>
			<td><?php
				if ( is_array($opt_params[2]) ) { ?>
					<select name="<?php echo $opt_key; ?>" id="<?php echo $opt_key; ?>" >
						<?php
						foreach ($opt_params[2] as $choice) { 
							if ($choice == $se_options[$opt_key])
								echo "						<option value=\"$choice\" selected=\"selected\">$choice</option>\n";
							else
								echo "						<option value=\"$choice\">$choice</option>\n";
						}
						?>
					</select><?php
				} else { ?>
					<input name="<?php echo $opt_key; ?>" type="text" id="<?php echo $opt_key; ?>"
					 value="<?php echo $se_options[$opt_key]; ?>" size="<?php echo $opt_params[2]; ?>" />
				<?php } ?>
				<br /><?php echo $opt_params[3] ? '<small>'.$opt_params[3].'</small>' : ''; ?>
			</td>
			</tr>
		<?php } ?>
		</table>
		</fieldset>

		<hr />
		<p class="submit">
			<input type="submit" name="Submit" value="Update Options" />
		</p>
	</form>
</div>
<?php
}

//
// Mime type extension
//
function se_upload_mimes($mimes)
{
	return array_merge($mimes, array('sib|sco' => 'application/x-sibelius-score'));
}
add_filter('upload_mimes','se_upload_mimes');
?>